//
//  Either.swift
//  Do It
//
//  Created by Jim Dovey on 3/23/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

enum Either<Left, Right> {
    case left(Left)
    case right(Right)
    
    init(_ value: Left) {
        self = .left(value)
    }
    
    init(_ value: Right) {
        self = .right(value)
    }
    
    var left: Left? {
        if case let .left(value) = self {
            return value
        }
        return nil
    }
    
    var right: Right? {
        if case let .right(value) = self {
            return value
        }
        return nil
    }
    
    var isLeft: Bool {
        switch self {
        case .left: return true
        case .right: return false
        }
    }
    
    var isRight: Bool {
        switch self {
        case .left: return false
        case .right: return true
        }
    }
    
    func map<T>(_ transform: (Left) -> T) -> Either<T, Right> {
        switch self {
        case .left(let v): return Either<T, Right>(transform(v))
        case .right(let v): return Either<T, Right>(v)
        }
    }
    
    func map<T>(_ transform: (Right) -> T) -> Either<Left, T> {
        switch self {
        case .left(let v): return Either<Left, T>(v)
        case .right(let v): return Either<Left, T>(transform(v))
        }
    }
    
    func either<Result>(ifLeft: (Left) throws -> Result, ifRight: (Right) throws -> Result) rethrows -> Result {
        switch self {
        case let .left(v): return try ifLeft(v)
        case let .right(v): return try ifRight(v)
        }
    }
}
